# Prof-TC
# Decembre 2020
# Son Stéréo

print("_________________________________________________________")
print("Son stéréo")

import wave
import math
import winsound

print("Création d'un fichier audio au format WAV (PCM 8 bits stéréo 44100 Hz)")
print("Son de forme sinusoïdale sur chaque canal\n")

print("_________________________________________________________")

NomFichier = 'son.wav'
Monson = wave.open(NomFichier,'w') # instanciation de l'objet Monson

nbCanal = 2    # stéreo
nbOctet = 1    # taille d'un échantillon : 1 octet = 8 bits
fech = 44100   # fréquence d'échantillonnage

frequenceG = float(input("Donner la fréquence du son du canal de gauche en Hertz: fg = "))
frequenceD = float(input("Donner la fréquence du son du canal de droite en Hertz: fd = "))
niveauG = float(input("Donner l'amplitude du son du canal de gauche (0 à 1): Vg = "))
niveauD = float(input("Donner l'amplitude du son du canal de droite (0 à 1): Vd = "))
duree = float(input("Donner la durée du signal sonore en seconde: T = "))

print("_________________________________________________________")

nbEchantillon = int(duree*fech)
print("Le nombre d'échantillons est: ",nbEchantillon)

print("_________________________________________________________")

parametres = (nbCanal,nbOctet,fech,nbEchantillon,'NONE','not compressed')# tuple
Monson.setparams(parametres)    # création de l'en-tête (44 octets)

# niveau max dans l'onde positive : +1 -> 255 (0xFF)
# niveau max dans l'onde négative : -1 ->   0 (0x00)
# niveau sonore nul :                0 -> 127.5 (0x80 en valeur arrondi)

amplitudeG = 127.5*niveauG
amplitudeD = 127.5*niveauD

print("Veuillez patienter pendant le calcul du signal sonore")

print("_________________________________________________________")

for i in range(0,nbEchantillon):
    # canal gauche
    # 127.5 + 0.5 pour arrondir à l'entier le plus proche
    valG = wave.struct.pack('B',int(128.0 + amplitudeG*math.sin(2.0*math.pi*frequenceG*i/fech)))
    # canal droit
    valD = wave.struct.pack('B',int(128.0 + amplitudeD*math.sin(2.0*math.pi*frequenceD*i/fech)))
    Monson.writeframes(valG + valD) # écriture frame

Monson.close()

Fichier = open(NomFichier,'rb')
data = Fichier.read()
tailleFichier = len(data)
print("La taille du fichier ",NomFichier, " est de:", tailleFichier, " octets")
print("Lecture du contenu de l'en-tête (44 octets) :")
print("Le nombre d'octets de données est de:",tailleFichier - 44, "octets")
Fichier.close()


winsound.PlaySound('son.wav',winsound.SND_FILENAME)

print("_________________________________________________________")

print("Le signal sonore a été créé et enregistré sous le nom: son.wav")
print("_________________________________________________________")